---
generated_at: 2026-01-30 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-Wasm HotReload Test

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/index.html`（18行）
- E-02: `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/main.js`（28行）
- E-03: `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/Program.cs`（82行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは "Wasm HotReload Test" | E-01（7行目: `<title>Wasm HotReload Test</title>`） | ○ |
| C-02 | ヘッダーは h3 で "Wasm HotReload Test" | E-01（15行目: `<h3 id="header">Wasm HotReload Test</h3>`） | ○ |
| C-03 | 結果表示に span#out を使用 | E-01（16行目: `<span id="out"></span>`） | ○ |
| C-04 | main.js を module として読み込み | E-01（11行目: `<script type='module' src="./main.js">`） | ○ |
| C-05 | dotnet.js をインポート | E-02（1行目: `import { dotnet } from './_framework/dotnet.js'`） | ○ |
| C-06 | DOTNET_MODIFIABLE_ASSEMBLIES を debug に設定 | E-02（15行目: `.withEnvironmentVariable("DOTNET_MODIFIABLE_ASSEMBLIES", "debug")`） | ○ |
| C-07 | appendElementOnExit を true に設定 | E-02（14行目: `.withConfig({ appendElementOnExit: true })`） | ○ |
| C-08 | TestMeaning メソッドを呼び出し | E-02（19行目: `const testMeaning = exports.Sample.Test.TestMeaning`） | ○ |
| C-09 | 結果を #out に表示 | E-02（21行目: `document.getElementById("out").innerHTML = '${ret}'`） | ○ |
| C-10 | tests_done ラベルを動的に追加 | E-02（4-7行目: `wasm_exit` 関数） | ○ |
| C-11 | WASM EXIT をコンソール出力 | E-02（9行目: `console.log('WASM EXIT ${exit_code}')`） | ○ |
| C-12 | TestMeaning に JSExport 属性 | E-03（18行目: `[JSExport]`） | ○ |
| C-13 | MetadataUpdater.GetCapabilities を使用 | E-03（24-26行目: `GetCapabilities` の呼び出し） | ○ |
| C-14 | 初期状態で "OLD STRING" を検証 | E-03（37-39行目: `if ("OLD STRING" != r)`） | ○ |
| C-15 | 1回目更新後に "NEW STRING" を検証 | E-03（43-45行目: `if ("NEW STRING" != r)`） | ○ |
| C-16 | 2回目更新後に "NEWEST STRING" を検証 | E-03（49-51行目: `if ("NEWEST STRING" != r)`） | ○ |
| C-17 | 成功時は 42 を返却 | E-03（21行目: `const int success = 42`） | ○ |
| C-18 | 関連機能は Mono, WebAssembly Workload, Reflection.Emit | E-05（25行目: 画面No 25 のマッピング） | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認できました。不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に根拠があり、ソースコードと整合しています

## 6) レビュアーチェックリスト（最小）

- [ ] index.html、main.js、Program.cs のコード内容が設計書の記述と一致しているか確認
- [ ] ホットリロード機能が正しく動作するか確認
- [ ] デルタファイルが正しく生成・適用されるか確認
- [ ] テスト結果 42 が正しく返却されるか確認
